#ifndef ZMODELER_STRUCT_BASE_H_INCLUDED
#define ZMODELER_STRUCT_BASE_H_INCLUDED
// 3D Point
class tNormalVertex;
typedef struct DllExport tPOINT
{
  float x;
  float y;
  float z;
  tPOINT();
  tPOINT(float _x, float _y, float _z);
//operators:
  tPOINT& operator+=(const tPOINT& p);
  tPOINT& operator-=(const tPOINT& p);
  tPOINT& operator*=(const float val);
  void Min(const tPOINT& p);
  void Max(const tPOINT& p);
  void Min(const tNormalVertex* pv);
  void Max(const tNormalVertex* pv);
  bool operator < (const tPOINT& p);
  bool operator <= (const tPOINT& p);
  bool operator > (const tPOINT& p);
  bool operator >= (const tPOINT& p);
  friend DllExport tPOINT operator+(const tPOINT lp, const tPOINT rp);
  friend DllExport tPOINT operator-(const tPOINT lp, const tPOINT rp);
  friend DllExport float operator*(const tPOINT lp, const tPOINT rp);
}tPOINT;

////////////////////
// 2D Point
typedef struct DllExport tPOINT2D
{
  float x;
  float y;
  tPOINT2D();
  tPOINT2D(float _x, float _y);
//operators:
  tPOINT2D& operator+=(const tPOINT2D& p);
  tPOINT2D& operator-=(const tPOINT2D& p);
  tPOINT2D& operator*=(const float val);
  void Min(const tPOINT2D& p);
  void Max(const tPOINT2D& p);
  bool operator < (const tPOINT2D& p);
  bool operator <= (const tPOINT2D& p);
  bool operator > (const tPOINT2D& p);
  bool operator >= (const tPOINT2D& p);
  friend DllExport tPOINT2D operator+(const tPOINT2D lp, const tPOINT2D rp);
  friend DllExport tPOINT2D operator-(const tPOINT2D lp, const tPOINT2D rp);
  friend DllExport float operator*(const tPOINT2D lp, const tPOINT2D rp);
}tPOINT2D;

#endif

